<?php
/**
 * Account Lock
 * https://webenginecms.org/
 * 
 * @version 1.0.0
 * @author Lautaro Angelico <http://lautaroangelico.com/>
 * @copyright (c) 2013-2019 Lautaro Angelico, All Rights Reserved
 * @build w3c8c718b75a0f1fa1a557f7f9d70877
 */

// namespace
namespace Plugin\AccountLock;

// plugin root
define('__PATH_ACCOUNTLOCK_ROOT__', __PATH_PLUGINS__.'accountlock/');

// plugin root
define('__ACCOUNTLOCK_HOME__', __BASE_URL__.'accountlock/');

// admincp
$extra_admincp_sidebar[] = array(
    'Account Lock', array(
        array('Settings','accountlock&page=settings')
    )
);

if(file_exists(__PATH_ACCOUNTLOCK_ROOT__ . 'languages/'.config('language_default', true).'/language.php')) {
	// attempt to load same language as website
	if(!@include_once(__PATH_ACCOUNTLOCK_ROOT__ . 'languages/'.config('language_default', true).'/language.php')) throw new Exception('Error loading account lock language file.');
} else {
	// load default language file (en)
	if(!@include_once(__PATH_ACCOUNTLOCK_ROOT__ . 'languages/en/language.php')) throw new Exception('Error loading account lock language file.');
}

// load classes
if(!@include_once(__PATH_ACCOUNTLOCK_ROOT__ . 'classes/class.accountlock.php')) throw new Exception(lang('accountlock_error_1', true));